org 100h
  mov ax,0x4f02
  mov bx,0x117  ; 1024x768, 16bit
  int 10h

  push 0xa000
  pop es

  fninit

;  xor bp,bp  ; bp = n_frame (time_in_s = bp/60)
M:
  fldln2
  fldl2e         ;; 1.4427 0.6931

  push bp
  fild word[-4]  ;; n_frame . .
  pop bp
;  fidiv word[C240] ;; t=n_frame/240 . .

  fmul st1,st0
  fmul st2,st0   ;; t t3=1.4427*t t2=0.6931*t
  fsincos        ;; c=cos(t) s=sin(t) t3=1.4427*t t2=0.6931*t

  fld st3
  fcos           ;; cos(t2) . . . .
  fidiv word[C10];; cos(t2)/10 . . . .
  fisubr word[C1] ;; scale=1-cos(t2)/10 c s t3 t2
  fmul st1,st0
  fmulp st2,st0  ;; C=c*scale S=s*scale t3 t2
  fstp dword[C]
  fstp dword[S]
  fstp dword[T3]
  fstp dword[T2]

  xor dx,dx  ; page: 0..23 | y: 0..768
P:
  mov ax,0x4f05  ; each line: set window, assume 64kB granularity
  xor bx,bx      ; bh=0 bl=window=0 dx=page
  int 10h

  xor di,di  ; di=pixel adr

             ; x: 0..1024
Q:
  fldz
  fldz
  fldz       ; R=0 G=0 B=0

  mov ax,di
  shrd ax,dx,11
  sub ax,768/2     ; ax = y[-384..383]
  push ax
  fild word[-4]
  fidiv word[C384] ;; y[-1..1] R G B
  pop ax

  mov ax,di
  shr ax,1
  and ax,1023
  sub ax,1024/2    ; ax = x[-512..511]
  push ax
  fild word[-4]
  fidiv word[C384] ;; x[-1.33..1.33] y[-1..1] R G B
  pop ax

  call LEN
  fmul dword[CHALF]  ;; d=sqrt(x*x+y*y)/2 x y R G B
  
  

  fstp dword[D]   ;; x y R G B

  xor cx,cx  ; cx = i
I:
  ; rotate and scale
  ;[x] = [C -S]*[x]
  ;[y]   [S  C] [y]

  fld st1
  fld st1        ;; x y x y R G B

  fld dword[S]   ;; S x y x y R G B
  fmul st1,st0
  fmulp st2,st0  ;; Sx Sy x y R G B

  fld dword[C]   ;; C Sx Sy x y R G B
  fmul st3,st0
  fmulp st4,st0  ;; Sx Sy Cx Cy R G B

  faddp st3,st0  ;; Sy Cx y=Sx+Cy R G B
  fsubp st1,st0  ;; x=Cx-Sy y=Sx+Cy R G B

  ; fold: square fold for now

  fsub dword[CHALF] ;; x=x-0.5 y R G B
  fist dword[TMP]
  fisub dword[TMP] ;; x=x-round(x) y R G B

  fxch st1
  fsub dword[CHALF] ;; y=y-0.5 x R G B
  fist dword[TMP]
  fisub dword[TMP]
  fxch st1         ;; x y=y-round(y) R G B

  ; interfering concentric circles
  call LEN
  fimul word[C5]   ;; 5*length(x,y) x y R G B
  fadd dword[D]
  fsub dword[T3]
  fcos
  fidivr word[C1]  ;; k=1/cos(d - t3 + 5*length(x,y)) x y R G B


  ; RGB += k * ( 0.5 + cos(3*(i/100 - d + t2) + vec3(2,1,0)) );
  push cx
  fild dword[-4]
  fidiv word[C100] ;; i/100 k x y R G B
  pop cx
  fsub dword[D]
  fadd dword[T2]
  fimul word[C3]   ;; q=3*(i/100 - d + t2) k x y R G B

  fld st0
  fcos             ;; cos(q) q k x y R G B
  fadd dword[CHALF]
  fmul st2         ;; k*(cos(q)+0.5) q k x y R G B
  faddp st7,st0    ;; q k x y R G B+=k*(cos(q)+0.5)

  fiadd word[C1]   ;; q=q+1 k x y R G B

  fld st0
  fcos             ;; cos(q) q k x y R G B
  fadd dword[CHALF]
  fmul st2         ;; k*(cos(q)+0.5) q k x y R G B
  faddp st6,st0    ;; q k x y R G+=k*(cos(q)+0.5) B

  fiadd word[C1]   ;; q=q+1 k x y R G B

  fld st0
  fcos             ;; cos(q) q k x y R G B
  fadd dword[CHALF]
  fmul st2         ;; k*(cos(q)+0.5) q k x y R G B
  faddp st5,st0    ;; q k x y R+=k*(cos(q)+0.5) G B

  fcompp           ;; x y R G B

  inc cx
  cmp cl,16
  jne I

  fcompp           ;; R G B

  ; sum = sum*sum/5000;  // square the sum for better contrast
  mov cl,3
COL:
  push ax
  fmul st0
  fidiv word[CCOL]  ;; R*R/5000*32 | G*G/5000*32 B*B/5000*32
  fistp word[-4]
  pop ax
  cmp ax,31
  jb NO_CLAMP
  mov ax,31
NO_CLAMP:          ; ax=R ax=G,bx=R bx=G,si=R,ax=B
  xchg ax,bx       ; bx=R bx=G,ax=R ax=G,si=R,bx=B
  xchg ax,si       ;      bx=G,si=R si=G,ax=R,bx=B
  loop COL         ;;

  ; combine RGB into rrrr|rggg|gg.b|bbbb
  shl ax,11
  shl si,6
  add ax,si
  add ax,bx

  stosw

  test di,di
  jnz Q

  inc dx
  cmp dl,768/32
  jb P

  inc bp ; n_frame++

  in al,60h ; ESC check
  cmp al,1
  jne M

  mov ax,3 ; text mode
  int 10h
  ret

LEN: ;; x y -> r=sqrt(x*x+y*y)
  fld st1
  fmul st0
  fld st1
  fmul st0
  faddp st1,st0
  fsqrt
  ret


C1    dw 1
C3    dw 3
C5    dw 5
C10   dw 10
C100  dw 100
C240  dw 240
C384  dw 384
CCOL  dw 5000/32*16*16/24/24

;C32 dw 32

CHALF dd 0.5

section .bss

C resd 1
S resd 1
T3 resd 1
T2 resd 1
D resd 1
TMP resd 1
